<div class="col-xl-4">
    <div class="card border-0 rounded-4 mb-4" style="background-color: #f8f9fa;">
        <div class="card-body p-4">

            {{-- Working Status --}}
            <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-briefcase me-2"></i>{{ __('Working Status') }}
                </h6>
                <div class="ms-auto" style="width: 40%;">
                    <form action="{{ route('admin.order.status-update', $order->id) }}" method="POST" id="status-form">
                        @csrf
                        @method('PATCH') {{-- Use PATCH for updating an existing resource --}}
                        <select name="status" class="form-select" onchange="document.getElementById('status-form').submit();">
                            @foreach(\App\Constants\OrderStatus::STATUS as $key => $value)
                                <option value="{{ $value }}" @selected($value == $order->status) >{{ ucfirst($value) }}</option>
                            @endforeach
                        </select>
                    </form>
                </div>
            </div>



            {{-- Service --}}
            <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-cogs me-2"></i>{{ __('Service') }}
                </h6>
                <div class="fw-bold text-primary ms-auto">{{ _tr($order->service->name) }}</div>
            </div>

            {{-- Client --}}
            <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-user me-2"></i>{{ __('Client') }}
                </h6>
                <div class="fw-bold text-dark ms-auto">{{ $order->user->full_name }}</div>
            </div>

            {{-- Price --}}
            <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-dollar-sign me-2"></i>{{ __('Price') }}
                </h6>
                <div class="fw-bold text-success ms-auto">{{ setting('currency_symbol') . $order->transaction->amount }}</div>
            </div>

            {{-- Payment Status --}}
            <div class="info-section mb-4 d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-credit-card me-2"></i>{{ __('Payment Status') }}
                </h6>
                <div class="fw-bold ms-auto">
                                <span class="badge bg-{{ $paymentStatus }} text-white py-1 px-3 rounded-pill" style="font-size: 0.85rem;">
                                    {{ strtoupper($order->transaction->status) }}
                                </span>
                </div>
            </div>

            {{-- Order Date --}}
            <div class="info-section d-flex justify-content-between align-items-center">
                <h6 class="text-muted d-flex align-items-center mb-0">
                    <i class="fas fa-calendar-alt me-2"></i>{{ __('Order Date') }}
                </h6>
                <div class="fw-bold text-secondary ms-auto">{{ ucwords($order->created_at_time) }}</div>
            </div>

        </div>
    </div>
</div>
