@extends('backend.order.index')
@push('style')
    @include('backend.order.partial._style')
@endpush

@section('title', __('Order Manage'))
@section('order_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
        <a href="{{ route('admin.order.working') }}"  class="btn btn-info float-end">
            <x-icon name="back" height="24"/> {{ __('Back') }}
        </a>
    </div>
@endSection

@section('order_content')
    <div class="container-fluid p-4">
        <div class="row">
            {{-- Order Task List Section --}}
            @include('backend.order.task.list')

            {{-- Sidebar Info Section --}}
            @include('backend.order.partial._sidebar')
        </div>
    </div>

    {{-- Create Task Modal  & Edit Task Modal --}}
    @include('backend.order.task.create')
    @include('backend.order.task.edit')
    @include('backend.order.task.show')

@endsection
@push('script')
   @include('backend.order.partial._script')
@endpush
