@extends('backend.order.index')
@section('title', $title)
@section('order_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection

@section('order_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="fs-2 d-flex justify-content-end mb-2">
                <form action="{{ route('admin.order.history') }}" class="row g-2 align-items-end">

                    <div class="col-auto">
                        <input type="hidden" name="daterange" value="{{ request('daterange') }}">
                        <div class="input-group">
                            <div id="reportrange" class="form-control">
                                <i class="fa-solid fa-calendar-days"></i>&nbsp;
                                <span></span><i class="fa-solid fa-angle-down mx-2"></i>
                            </div>
                        </div>
                    </div>


                    {{-- Extended Search Input --}}
                    <div class="col-auto">
                        <div class="input-group">
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                   placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">
                            <button type="submit" class="btn btn-info">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Client Name') .' | ' . __('Order Date') }}</th>
                        <th>{{ __('Service Name') }}</th>
                        <th>{{ __('Order Number') .' | ' . __('Price') }}</th>
                        <th>{{ __('Working Status') }}</th>
                        <th>{{ __('Payment Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($orders as $order)
                        @php
                            $workingStatus = ['pending' => 'info', 'working' => 'secondary', 'completed' => 'success','cancel' => 'danger'][$order->status] ?? 'blue';
                            $transactionStatus = ['pending' => 'info',  'completed' => 'success', 'failed' => 'danger' ][$order->transaction->status] ?? 'blue';
                            $transaction = $order->transaction;
                            $isPaymentCompleted = $transaction->status == \App\Constants\TxnStatus::COMPLETED;
                            $isManualPending = $transaction->method_type == \App\Constants\MethodType::MANUAL && $transaction->status == \App\Constants\TxnStatus::PENDING;
                        @endphp
                        <tr class="align-middle ">
                            <td class="fw-bold">
                                <div class="d-flex align-items-center">
                                    <img class="me-2 rounded-circle" width="36" height="36" alt="Image placeholder" src="{{ asset($order->user->avatar) }}">
                                    <div>
                                        <a href="{{ route('admin.users.edit', $order->user->id) }}" class="text-secondary fw-bold">{{ $order->user->full_name }}</a>
                                        <div class="text-muted small">{{ ucwords($order->created_at_time) }}</div>
                                    </div>
                                </div>
                            </td>
                            <td class="fw-bold">
                                {{ _tr($order->service->name) }}
                            </td>
                            <td>
                                <div class="fw-bold">{{ $order->order_number }}</div>
                                <div class="text-muted small">{{ setting('currency_symbol').ucwords($order->transaction->amount . ' ' . setting('site_currency')) }}</div>
                            </td>
                            <td class="fw-bold">
                                <span class="badge bg-{{ $workingStatus }} ">{{ strtoupper($order->status) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $transactionStatus }} ">{{ strtoupper($order->transaction->status) }}</span>
                            </td>
                            <td>
                                @if(!isset($paymentAction))
                                    @if($isPaymentCompleted)
                                        <a href="{{ route('admin.order.manage', $order->id) }}"
                                           class="btn btn-sm btn-primary">
                                            <x-icon name="manage" height="20"/> {{ __('Manage') }}
                                        </a>
                                    @else
                                        <span class="btn btn-sm btn-warning">{{ __('Manage Available After Payment') }} </span>
                                    @endif
                                @endif

                                @if(isset($paymentAction) && $isManualPending)
                                    <button class="btn btn-tertiary edit-modal"
                                            data-edit-url="{{ route('admin.deposit.deposit-request-action', $transaction->txid) }}"
                                            type="button">
                                        <x-svg i="action" height="20"/> {{ __('Approve/Decline') }}
                                    </button>
                                @endif

                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
        <div class="d-flex justify-content-end me-4 mb-2">
            {{ $orders->links() }}
        </div>

        @if(!$orders->count())
            <h4 class="text-center text-muted py-3">{{ __('No data found') }}</h4>
        @endif
    </div>

    @include('backend.deposit.partials._deposit_action_modal')

@endsection
@push('script')
    <script>
        $(document).ready(function () {
            'use strict';
            editFormByModal('deposit-action-modal', 'deposit-action-data',true,true);
        });
    </script>

@endpush
