@extends('backend.layouts.app')
@section('title')
    {{ __('Notifications Template') }}
@endsection
@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">🔔 {{ __('Notifications Template') }}</h1>
            </div>

            <div class="btn-toolbar  mb-md-0 mb-2 ">
                <a href="{{ route('admin.settings.plugin_type', 'notification') }}" class="btn btn-sm btn-secondary d-inline-flex align-items-center">
                    <x-icon height="24" width="24" class="me-2" name="bell-3" />
                    {{ __('Notification Setting') }}
                </a>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Name') .' | ' . __('Type') }}</th>
                        <th>{{ __('To Notify') }}</th>
                        <th>{{ __('Push Status') }}</th>
                        <th>{{ __('Mail Status') }}</th>
                        <th>{{ __('Template Manage') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($notifyTemplates as $notifyTemplate)
                        <tr class="align-middle">
                            <td>
                                <div class="d-flex align-items-center">
                                    <x-icon :name="$notifyTemplate->icon" height="40" width="40" class="me-2 text-muted" />
                                    <div>
                                        <div class="fw-bold">{{  $notifyTemplate->name }}</div>
                                        <div class="text-muted small">{{ $notifyTemplate->info }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="badge bg-{{ $notifyTemplate->type == 'user' ? 'info' : 'secondary' }} text-white }}">
                                    <i class="fa-solid fa-{{ $notifyTemplate->type == 'user' ? 'user' : 'user-crown' }} me-1"></i>
                                    {{ ucwords($notifyTemplate->type) }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $notifyTemplate->push_status ? 'success' : 'danger' }} text-white">{{  $notifyTemplate->push_status ? __('ACTIVE') : __('INACTIVE') }}</span>
                            </td>
                            <td>
                                <span class="badge bg-{{ $notifyTemplate->mail_status ? 'success' : 'danger' }} text-white">{{  $notifyTemplate->mail_status ? __('ACTIVE') : __('INACTIVE') }}</span>
                            </td>
                            <td>
                                <div class="btn-group" role="group" aria-label="Basic example">
                                    <a href="{{ route('admin.notifications.push-template-manage', $notifyTemplate->id) }}" class="btn btn-sm btn-info "><x-icon name="bell-edit" height="22" width="22"  /> {{ __('Manage Push') }}</a>
                                    <a href="{{ route('admin.notifications.mail-template-manage', $notifyTemplate->id) }}" class="btn btn-sm btn-tertiary"><x-icon name="mail-edit" height="20" width="20" class="me-1" /> {{ __('Manage Mail') }}</a>
                                </div>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
