@extends('backend.layouts.app')

@section('title')
    {{ $pushTemplate->name . ' ' . __('Manage') }}
@endsection

@section('content')
    <div class="py-4">
        <div class="d-flex justify-content-between align-items-center flex-wrap w-100">
            <h1 class="h4 mb-3 mb-lg-0">{{ __('Push Template Management') }}</h1>
            <div class="btn-toolbar mb-lg-0">
                <a href="{{ route('admin.notifications.template') }}" class="btn btn-sm btn-tertiary d-inline-flex align-items-center">
                    <x-svg i="back" />
                    {{ __('Back to Templates') }}
                </a>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header p-3">
            <h5 class="mb-0 mx-2">
                {{ $pushTemplate->name }} <span class="text-muted">{{ __('for') }}</span> {{ ucwords($pushTemplate->type) }}
            </h5>
        </div>
        <div class="card-body">
            <form action="{{ route('admin.notifications.push-template') }}" method="POST">
                @csrf
                <input type="hidden" name="template_id" value="{{ $pushTemplate->id }}">

                <!-- Message Input -->
                <div class="mb-4">
                    <label for="message" class="form-label fw-bold">{{ __('Message Content') }}</label>
                    <textarea class="form-control" id="message" name="message" rows="6" placeholder="{{ __('Type your message here...') }}">{{ old('message', $pushTemplate->push_message) }}</textarea>
                    <div class="form-text mt-2">
                        {{ __('Available variables/shortcode :') }}
                    @foreach($pushTemplate->variables as $variable)
                            <span class="badge bg-danger"> {{ '{$'.$variable.'}' }} </span>
                        @endforeach
                    </div>
                </div>

                <!-- Status Switch -->
                <div class="mb-4">
                    <div class="form-check form-switch">
                        <!-- Hidden input to provide a default value when the checkbox is unchecked -->
                        <input type="hidden" name="status" value="0">
                        <input class="form-check-input" type="checkbox" role="switch" name="status" value="1" id="status" @checked($pushTemplate->push_status)>
                        <label class="form-check-label" for="status">{{ __('Activate Push Notifications') }}</label>
                    </div>
                </div>

                <!-- Submit Button -->
                <div class="d-flex justify-content-end">
                    <button type="submit" class="btn btn-info d-flex align-items-center">
                        <x-icon name="check" height="20" width="20" />
                        <span class="ms-2">{{ __('Update Template') }}</span>
                    </button>
                </div>
            </form>
        </div>
    </div>
@endsection
