@php use App\Constants\NotificationType; @endphp
@extends('backend.layouts.app')
@section('title')
    {{ __('Notifications') }}
@endsection
@section('content')

    <div class="py-4">
        <div class="d-flex justify-content-between w-100 flex-wrap">
            <div class="mb-3 mb-lg-0">
                <h1 class="h4">🔔 {{ __('Notifications') }}</h1>
            </div>
        </div>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <div class="list-group">
                @foreach($notifications as $notification)
                    <a href="{{ $notification->data['action_link'] }}" data-id="{{ $notification->id }}" class="list-group-item py-3 border bg-light rounded mb-2 read-notification">
                        <div class="d-flex align-items-start">
                            <div class="me-3">
                                {{-- Avatar with background and matching icon color --}}
                                <div class="p-2 bg-gray-200 rounded-1">
                                    <x-icon height="32" width="32"
                                            name="{{ NotificationType::ICON[$notification->data['type']] }}"
                                            class="text-{{ (isset($notification->data['status']) && $notification->data['status'] == 'rejected') ? 'danger' : 'success' }}"/>
                                </div>
                            </div>
                            <div class="flex-grow-1">
                                <div class="fw-bold text-truncate">
                                    {{ $notification->data['message'] }}
                                </div>
                                <small class="text-muted">
                                    {{ $notification->created_at->format('d M, Y H:i A') }}
                                </small>
                            </div>
                            @if($notification->read_at == null )
                                <div class="ms-auto align-self-end">
                                    <i class="fa-sharp fa-solid fa-bell-on text-warning"></i>
                                </div>
                            @endif
                        </div>
                    </a>

                @endforeach

                {{-- Pagination --}}
                <div class="d-flex justify-content-end mt-3">
                    {{ $notifications->links() }}
                </div>

                {{-- No notifications message --}}
                @if(count($notifications) == 0)
                    <div class="alert alert-info">
                        {{ __('No Notification found') }}
                    </div>
                @endif
            </div>
        </div>
    </div>

@endsection
@push('script')
    <script>
        'use strict';
        $(document).on('click', '.read-notification', function() {
            const notificationId = $(this).data('id');
            const url = "{{ route('admin.notifications.markAsRead', ':id') }}".replace(':id', notificationId);

            // Make AJAX request to mark notification as read
            $.get(url)
                .done(function(response) {
                    console.log('Notification marked as read:', response);
                    // Optionally remove notification from the UI or update its status
                })
                .fail(function(jqXHR, textStatus, errorThrown) {
                    console.error('Error marking notification as read:', textStatus, errorThrown);
                    // Optionally display an error message to the user
                });
        });
    </script>
@endpush
