<a class="nav-link text-dark notification-bell {{ $notifications->count() > 0 ? 'unread' : '' }} dropdown-toggle"
   data-unread-notifications="true" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
    <x-icon name="bell-1"/>
</a>
<div class="dropdown-menu dropdown-menu-lg dropdown-menu-center mt-3 py-0 ms-4">
    <div class="list-group list-group-flush">
        <a href="javascript:void(0)" class="text-center text-primary fw-bold border-bottom border-light py-3">{{ __('Notifications') }}</a>

        <div id="notificationList">
            @foreach($notifications as $notification)
                <a href="{{ $notification->data['action_link'] }}" data-id="{{ $notification->id }}"
                   class="list-group-item list-group-item-action border-bottom read-notification">
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <img src="{{ asset($notification->data['user_avatar']) }}" class="avatar-md rounded" alt="">
                        </div>
                        <div class="col ps-0 ms-2">
                            <div class="d-flex justify-content-between align-items-center">
                                <h4 class="h6 mb-0 text-small">{{ $notification->data['user_name'] }}</h4>
                                <small class="text-success">{{ $notification->created_at->diffForHumans() }}</small>
                            </div>
                            <p class="font-small mt-1 mb-0">{{ $notification->data['message'] }}</p>
                        </div>
                    </div>
                </a>
            @endforeach
        </div>

        @if($notifications->isEmpty())
            <h5 class="text-center text-muted py-3">{{ __('No new notifications') }}</h5>
        @endif

        <div class="d-flex justify-content-between p-2">
            @if(!$notifications->isEmpty())
                <a href="{{ route('admin.notifications.read-all') }}" class="btn btn-sm btn-info">
                    <i class="fa-sharp fa-solid fa-bell me-1"></i> {{ __('Mark all as read') }}
                </a>
            @endif
            <a href="{{ route('admin.notifications.index') }}" class="btn btn-sm btn-tertiary {{ $notifications->count() == 0 ? 'w-100' : '' }}">
                <i class="fa-sharp fa-solid fa-eye me-1"></i> {{ __('View all') }}
            </a>
        </div>
    </div>
</div>
