
{{-- Deposit Details Card --}}
<div class="card rounded-lg mb-1">
    <div class="card-body p-2">
        <div class="d-flex justify-content-between align-items-center">
            <div class="fw-bold">{{ __('Payment Method') }}</div>
            <div class="text-end"><strong>{{ title($depositRequest->method) }}</strong></div>
        </div>
<hr>
        <div class="d-flex justify-content-between align-items-center mt-2">
            <div class="fw-bold">{{ __('User Requested Amount') }}</div>
            <div class="text-end"><strong>{{ $depositRequest->amount . ' ' . $depositRequest->currency }}</strong></div>
        </div>
        @if($depositRequest->pay_currency != $depositRequest->currency)
            <div class="d-flex justify-content-between align-items-center mt-2">
                <div class="fw-bold">{{ __('Admin Received Amount') }}</div>
                <div class="text-end"><strong>{{ $depositRequest->pay_amount . ' ' . $depositRequest->pay_currency }}</strong></div>
            </div>
        @endif
    </div>
</div>

{{-- Additional Information Card --}}
<div class="card rounded-lg mb-1">
    <div class="card-body p-2">
        @foreach($depositRequest->array_data as $key => $value)
            <div class="mb-2">
                @if($value != new stdClass())
                    @if(file_exists('assets/'.$value))
                        <div class="fw-bold mb-1">{{ $key }}</div>
                        <img src="{{ asset($value) }}" alt="{{ $key }}" class="img-fluid rounded-3" style="max-width: 100%; height: auto; object-fit: contain;" />
                    @else
                        <div class="d-flex justify-content-between align-items-center">
                            <div class="fw-bold">{{ $key }}</div>
                            <div class="text-end"><strong>{{$value }}</strong></div>
                        </div>
                    @endif
                @endif
            </div>
        @endforeach
    </div>
</div>

{{-- Form for Approval/Rejecting Deposit --}}
<div class="card rounded-lg">
    <div class="card-body p-2">
        <form action="{{ route('admin.deposit.deposit-request-action', $depositRequest->txid) }}" method="post" class="needs-validation" novalidate>
            @csrf
            <div class="mb-2">
                <label for="detailsMessage" class="form-label">{{ __('Details Message (Optional)') }}</label>
                <textarea id="detailsMessage" name="message" class="form-control" placeholder="{{ __('Details Message') }}" rows="4"></textarea>
            </div>
            <div class="d-flex justify-content-end gap-2">
                <button type="submit" name="approve" value="yes" class="btn btn-success text-white">
                    <x-svg i="check"  height="20" /> {{ __('Approve Payment') }}
                </button>
                <button type="submit" name="reject" value="yes" class="btn btn-danger">
                    <x-svg i="close"  height="20" /> {{ __('Reject Payment') }}
                </button>
            </div>
        </form>
    </div>
</div>
