<script>
    $(document).ready(function () {
        'use strict';

        let i = @json($fieldCount); // Initialize field count


        // Handle payment gateway selection change
        $('#select-payment-gateway').on('change', function () {
            const gatewayId = $(this).val();
            const url = `{{ route('admin.payment.gateway-currency', ':gateway_id') }}`.replace(':gateway_id', gatewayId);

            $.get(url, function (data) {
                $('#currency-list').html(data.view);
                $('#currency-selected').text(data.payCurrency);
            });
        });

        // Handle currency list change
        $('#currency-list').on('change', function () {
            const selectedCurrency = $(this).val();
            const currencies = @json(getJsonData('currencies'));

            $('#currency-selected').text(selectedCurrency);

            const currencySymbol = currencies['fiat'].find(currency => currency['code'] === selectedCurrency) ||
                currencies['crypto'].find(currency => currency['code'] === selectedCurrency);

            if (currencySymbol) {
                $('#currency-symbol').val(currencySymbol['symbol']);
            }
        });

        // Handle custom currency input
        $('#custom_currency').on('keyup', function () {
            $('#currency-selected').text($(this).val());
        });

        // Toggle conversion rate input
        $('#conversion_rate_live').on('click', function () {
            $('#conversion_rate').prop('disabled', $(this).is(':checked')).val($(this).is(':checked') ? null : $('#conversion_rate').val());
        });

        // Use event delegation for dynamically added fields
        $(document).on('click', '.delete_field', function () {
            $(this).closest('.field-remove-row').remove();
        });

        // Add new dynamic form field
        $('#add-new-field').on('click', function () {
            const formTemplate = `@include('backend.deposit.method.partial._method_append_form_field', ['key' => '${i}'])`;
            $('.append-new-field').append(formTemplate);
            i++; // Increment index for unique field identification
        });
    });
</script>
