@extends('backend.deposit.index')
@section('title', title($type).' '. __('Methods'))
@section('deposit_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
        <a href="{{ route('admin.deposit.method.create', ['type' => $type]) }}"  class="btn btn-info float-end">
            <x-icon name="add"  height="24" />{{ __('Create').' '. title($type).' ' . __('Method') }}
        </a>
    </div>
@endSection

@section('deposit_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0 caption-top">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Logo') }}</th>
                        <th>{{ __('Name | Currency') }}</th>
                        <th>{{ __('Min | Max Deposit') }}</th>
                        <th>{{ __('Rate Type | Rate') }}</th>
                        <th>{{ __('Charge') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($paymentMethods as $paymentMethod)
                        <tr class="align-middle">
                            <td class="text-nowrap">
                                <img src="{{ asset($paymentMethod->logo_alt) }}" class="table-logo" alt="" >
                            </td>
                            <td class="text-start">
                                <strong class="text-muted">{{ title($paymentMethod->name) }}</strong>
                                <div class="small text-body-secondary">
                                    <span class="badge bg-secondary">{{ $paymentMethod->currency }}</span>
                                </div>
                            </td>
                            <td>
                                <div class="text-nowrap"><strong class="text-muted">{{ $paymentMethod->currency_symbol }}{{ $paymentMethod->min_deposit }}</strong></div>
                                <div class="small text-body-secondary text-nowrap"><strong class="text-muted">{{ $paymentMethod->currency_symbol }}{{ $paymentMethod->max_deposit }}</strong></div>
                            </td>
                            <td>
                                <div class="text-nowrap">
                                    @if($paymentMethod->conversion_rate_live)
                                        <strong class="text-danger">{{ __('LIVE') }}</strong>
                                    @else
                                        <strong class="text-primary">{{ __('LOCAL') }}</strong>
                                    @endif
                                </div>
                                <div class="small text-body-secondary text-nowrap">
                                    <strong>1 {{ setting('site_currency') }} = {{ $paymentMethod->conversion_rate }} {{ $paymentMethod->currency }}</strong>
                                </div>
                            </td>
                            <td>
                                <strong class="text-muted">
                                    @if($paymentMethod->charge_type == App\Constants\FixPctType::PERCENT)
                                        {{ $paymentMethod->charge }}%
                                    @else
                                        {{ $paymentMethod->currency_symbol }}{{ $paymentMethod->charge }}
                                    @endif
                                </strong>
                            </td>
                            <td>
                                <span class="badge bg-{{ $paymentMethod->status ? 'success' : 'danger' }}">{{ strtoupper($paymentMethod->status ? __('Active') : __('Inactive')) }}</span>
                            </td>
                            <td>
                                <a href="{{ route('admin.deposit.method.edit', $paymentMethod->id) }}" class="btn btn-info">
                                    <x-icon name="manage" height="20" /> {{ __('Manage') }}
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
                <div class="mt-3">
                    {{ $paymentMethods->links() }}
                </div>
            </div>

        </div>
    </div>
@endsection
