@extends('backend.deposit.index')
@section('title', title($paymentMethod->type).' '. __('Methods'))
@section('deposit_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
        <a href="{{ route('admin.deposit.method.type', ['type' => $type ?? $paymentMethod->type]) }}" class="btn btn-info float-end">
            <x-icon name="back" height="24"/>
            {{ __('Back') }}
        </a>
    </div>
@endSection

@section('deposit_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <form action="{{ route('admin.deposit.method.update', $paymentMethod->id) }}" method="post" enctype="multipart/form-data">
                @method('PUT')
                @csrf
                <input type="hidden" name="type" value="{{ $paymentMethod->type }}">

                <div class="row g-3 mb-3">
                    <div class="col-lg-6">
                        <label for="icon" class="form-label">{{ __('Logo') }}</label>
                        <x-img-up name="logo" :old="$paymentMethod->logo_alt" :ref="'coevs-payment-method-logo-'.$paymentMethod->id"/>
                    </div>
                </div>

                @if($paymentMethod->type === App\Constants\PaymentMethod::AUTOMATIC)
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <label for="role" class="form-label">{{ __('Payment Gateway') }}</label>
                            <select class="form-select" id="select-payment-gateway" name="payment_gateway_id" required>
                                <option selected disabled>{{ __('Select Payment Gateway') }}</option>
                                @foreach($paymentGateways as $gateway)
                                    <option value="{{ $gateway->id }}" @selected($paymentMethod->payment_gateway_id === $gateway->id)>{{ $gateway->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-6">
                            <label for="currency" class="form-label">{{ __('Supported Currency') }}</label>
                            <select class="form-select" id="currency-list" name="currency" required>
                                @foreach($paymentMethod->paymentGateway->currencies as $paymentCurrency)
                                    <option value="{{ $paymentCurrency }}" @selected($paymentMethod->currency === $paymentCurrency)>{{ $paymentCurrency }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                @endif

                <div class="row g-3 mb-3">
                    <div class="col-lg-6">
                        <label for="name" class="form-label">{{ __('Name') }}</label>
                        <input type="text" class="form-control" name="name" value="{{ $paymentMethod->name }}" placeholder="Name" required>
                    </div>
                    <div class="col-lg-6">
                        <label for="currency_symbol" class="form-label">{{ __('Currency Symbol') }}</label>
                        <input type="text" class="form-control" name="currency_symbol" value="{{ $paymentMethod->currency_symbol }}" id="currency-symbol" placeholder="Ex: $, BTC" required>
                    </div>
                </div>

                @if($paymentMethod->type == App\Constants\PaymentMethod::MANUAL)
                    <div class="row g-3 mb-3">
                        <div class="col-lg-6">
                            <label for="code" class="form-label">{{ __('Method Code') }}</label>
                            <input type="text" class="form-control" name="method_code" value="{{ $paymentMethod->method_code }}" placeholder="Ex: paypal-usd, custom-name-btc" required>
                        </div>
                        <div class="col-lg-6">
                            <label for="currency" class="form-label">{{ __('Currency') }}</label>
                            <input type="text" class="form-control" name="currency" id="custom_currency" value="{{ $paymentMethod->currency }}" placeholder="Ex: USD, BTC,etc.." required>
                        </div>
                    </div>
                @endif

                <div class="row g-3 mb-3">
                    <div class="col-lg-6">
                        <label for="conversion_rate" class="form-label">{{ __('Conversion Rate:') }}</label>
                        @if($paymentMethod->type == App\Constants\PaymentMethod::AUTOMATIC)
                            <a href="{{ route('admin.settings.plugin_type','exchange_rate') }}" class="badge bg-info">{{ __('Manage Exchange') }}</a>
                        @endif
                        <div class="input-group">
                            <span class="input-group-text">1 {{ setting('site_currency') }} =</span>
                            <input type="text" class="form-control" name="conversion_rate" id="conversion_rate" value="{{ $paymentMethod->conversion_rate }}" oninput="this.value = validateDouble(this.value)" aria-label="Amount (to the nearest dollar)" required>
                            @if($paymentMethod->type == App\Constants\PaymentMethod::AUTOMATIC)
                                <span class="input-group-text pt-0 pb-0">
                        <div class="form-check form-switch pt-2">
                            <input type="hidden" name="conversion_rate_live" value="0">
                            <input class="form-check-input" type="checkbox" id="conversion_rate_live" name="conversion_rate_live" value="1" @checked($paymentMethod->conversion_rate_live)>
                            <label class="form-check-label text-danger" for="conversion_rate_live">{{ __('Live') }}</label>
                        </div>
                    </span>
                            @endif
                            <span class="input-group-text" id="currency-selected">{{ $paymentMethod->currency }}</span>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <label for="charge" class="form-label">{{ __('Charge:') }}</label>
                        <div class="input-group evs-input-group">
                            <input type="text" class="form-control" name="charge" value="{{ $paymentMethod->charge }}" oninput="this.value = validateDouble(this.value)" placeholder="Charge" required>
                            <select name="charge_type" class="form-select input-group-select px-5">
                                @foreach(\App\Constants\FixPctType::getTypeWithSymbol() as $key => $value)
                                    <option value="{{ $key }}" @selected($key == $paymentMethod->charge_type)>{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row g-3 mb-3">
                    <div class="col-lg-6">
                        <label for="min_deposit" class="form-label">{{ __('Minimum Deposit:') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="min_deposit" value="{{ $paymentMethod->min_deposit }}" oninput="this.value = validateDouble(this.value)" aria-label="Amount (to the nearest dollar)" required>
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <label for="max_deposit" class="form-label">{{ __('Maximum Deposit:') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="max_deposit" value="{{ $paymentMethod->max_deposit }}" oninput="this.value = validateDouble(this.value)" aria-label="Amount (to the nearest dollar)" required>
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                    </div>
                </div>

                @if($paymentMethod->type == App\Constants\PaymentMethod::MANUAL)
                    <div class="mb-4">
                        <a href="javascript:void(0)" id="add-new-field" class="btn btn-info add-new-field mb-3">
                            <x-icon name="add" height="20"/> {{ __('Add New Field') }}
                        </a>
                        <div class="append-new-field me-2">
                            @foreach(json_decode($paymentMethod->fields,true) as $key => $value)
                                @include('backend.deposit.method.partial._method_append_form_field', ['key' => $key, 'field' => $value])
                            @endforeach
                        </div>
                        <div class="col-xl-12">
                            <label for="receive_payment_details" class="form-label">{{ __('Receive Payment Details:') }}</label>
                            <span id="summernote-field">
                    <textarea class="summernote form-control" name="receive_payment_details">{!! $paymentMethod->receive_payment_details !!}</textarea>
                </span>
                        </div>
                    </div>
                @endif

                <div class="row g-3 mb-3">
                    <div class="col-lg-4">
                        <label for="status" class="form-label">{{ __('Status') }}</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="status" value="1" @checked($paymentMethod->status)>
                        </div>
                    </div>
                </div>

                <div class="text-end">
                    <button class="btn btn-info" type="submit">
                        <x-icon name="check" height="20"/> {{ __('Update Payment Method') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

@endsection
@push('script')
    @include('backend.deposit.method.partial._script')
@endpush
