@extends('backend.deposit.index')
@section('title', title($type).' '. __('Methods'))
@section('deposit_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
        <a href="{{ route('admin.deposit.method.type', ['type' => $type]) }}" class="btn btn-info float-end">
            <x-icon name="back" height="24"/>
            {{ __('Back') }}
        </a>
    </div>
@endSection

@section('deposit_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <form action="{{ route('admin.deposit.method.store') }}" method="post" enctype="multipart/form-data">
                @csrf
                <input type="hidden" name="type" value="{{ $type }}">
                <div class="row mb-3">
                    <div class="col-lg-6 col-md-6 col-12">
                        <label class="form-label" for="icon">{{ __('Logo') }}</label>
                        <x-img-up name="logo"/>
                    </div>
                </div>
                @if($type === App\Constants\PaymentMethod::AUTOMATIC)
                    <div class="row mb-3">
                        <div class="col-lg-6 col-md-6 col-12">
                            <label class="form-label" for="role">{{ __('Payment Gateway') }}</label>
                            <select class="form-select" id="select-payment-gateway" name="payment_gateway_id" required>
                                <option selected disabled>{{ __('Select Payment Gateway') }}</option>
                                @foreach($paymentGateways as $gateway)
                                    <option value="{{ $gateway->id }}">{{ $gateway->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                            <label class="form-label" for="currency">{{ __('Supported Currency') }}</label>
                            <select class="form-select" id="currency-list" name="currency" required>
                                <option selected disabled>{{ __('Select First Payment Gateway') }}</option>
                            </select>
                        </div>
                    </div>
                @endif
                <div class="row mb-3">
                    <div class="col-lg-6 col-md-6 col-12">
                        <label class="form-label" for="name">{{ __('Name') }}</label>
                        <input class="form-control" type="text" name="name" placeholder="Name" required>
                    </div>
                    <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                        <label class="form-label" for="currency_symbol">{{ __('Currency Symbol') }}</label>
                        <input class="form-control" type="text" name="currency_symbol" id="currency-symbol"
                               placeholder="Ex: $, BTC"
                               required>
                    </div>
                </div>
                @if($type == App\Constants\PaymentMethod::MANUAL)
                    <div class="row mb-3">
                        <div class="col-lg-6 col-md-6 col-12">
                            <label class="form-label" for="code">{{ __('Method Code') }}</label>
                            <input class="form-control" type="text" name="method_code"
                                   placeholder="Ex: paypal-usd, custom-name-btc" required>
                        </div>

                        <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                            <label class="form-label" for="currency">{{ __('Currency') }}</label>
                            <input class="form-control" type="text" name="currency" id="custom_currency"
                                   placeholder="Ex: USD, BTC,etc.."
                                   required>
                        </div>
                    </div>
                @endif
                <div class="row mb-3">
                    <div class="col-lg-6 col-md-6 col-12">
                        <label class="form-label" for="conversion_rate">{{ __('Conversion Rate:') }}</label>
                        <div class="input-group">
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                            <input type="text" oninput="this.value = validateDouble(this.value)"
                                   name="conversion_rate" id="conversion_rate" class="form-control"
                                   aria-label="Amount (to the nearest dollar)">
                            @if($type == App\Constants\PaymentMethod::AUTOMATIC)
                                <span class="input-group-text pt-0 pb-0">
                                        <div class="form-check form-switch pt-2">
                                          <input type="hidden" name="conversion_rate_live" value="0">
                                          <input class="form-check-input" id="conversion_rate_live" type="checkbox"
                                                 name="conversion_rate_live" value="1">
                                          <label class="form-check-label text-danger" for="conversion_rate_live">
                                            {{ __('Live') }}
                                          </label>
                                        </div>
                                    </span>
                            @endif
                            <span class="input-group-text" id="currency-selected"></span>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                        <label class="form-label" for="currency_symbol">{{ __('Charge:') }}</label>
                        <div class="input-group">
                            <input class="form-control" type="text"
                                   oninput="this.value = validateDouble(this.value)"
                                   name="charge" placeholder="Charge" required>
                            <select name="charge_type" class="form-select input-group-select px-5">
                                @foreach(\App\Constants\FixPctType::getTypeWithSymbol() as $key => $value)
                                    <option value="{{ $key }}">{{ $value }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-lg-6 col-md-6 col-12">
                        <label class="form-label" for="currency_symbol">{{ __('Minimum Deposit:') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="min_deposit"
                                   oninput="this.value = validateDouble(this.value)"
                                   aria-label="Amount (to the nearest dollar)">
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                    </div>
                    <div class="col-lg-6 col-md-6 col-12 mt-md-0 mt-3">
                        <label class="form-label" for="currency_symbol">{{ __('Maximum Deposit:') }}</label>
                        <div class="input-group">
                            <input type="text" class="form-control" name="max_deposit"
                                   oninput="this.value = validateDouble(this.value)"
                                   aria-label="Amount (to the nearest dollar)">
                            <span class="input-group-text">{{ setting('site_currency') }}</span>
                        </div>
                    </div>
                </div>

                @if($type == App\Constants\PaymentMethod::MANUAL)
                    <div class="mb-3 mt-4">
                        <div class="col-xl-3 mb-3">
                            <a href="javascript:void(0)" id="add-new-field"
                               class="btn btn-info">
                                <x-icon name="add" height="20"/>{{ __('Add New Field') }}</a>
                        </div>
                        <div class="append-new-field mb-3 me-2">
                        </div>
                        <div class="col-xl-12">
                            <div class="site-input-groups fw-normal">
                                <label for="" class="form-label">{{ __('Receive Payment Details:') }}</label>
                                <div class="site-editor">
                                        <textarea class="summernote form-control"
                                                  name="receive_payment_details"></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                @endif

                <div class="row mb-3">
                    <div class="col-lg-4 col-md-4 col-4">
                        <label class="form-label" for="status">{{ __('Status') }}</label>
                        <div class="form-check form-switch">
                            <input class="form-check-input coevs-switch" type="checkbox" name="status" value="1">
                        </div>
                    </div>
                </div>
                <div class="text-end">
                    <button class="btn btn-info" type="submit">
                        <x-icon name="check" height="20"/> {{ __('Create Payment Method') }}
                    </button>
                </div>
            </form>
        </div>
    </div>

@endsection
@push('script')
    @include('backend.deposit.method.partial._script')
@endpush
