@extends('backend.deposit.index')
@section('title', __('Manual Deposit Request'))
@section('deposit_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection
@section('deposit_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="fs-2 d-flex justify-content-end mb-2">
                <form action="{{ route('admin.deposit.manual-request') }}" class="row g-2 align-items-end">

                    <div class="col-auto">
                        <input type="hidden" name="daterange" value="{{ request('daterange') }}">
                        <div class="input-group">
                            <div id="reportrange" class="form-control">
                                <i class="fa-solid fa-calendar-days"></i>&nbsp;
                                <span></span><i class="fa-solid fa-angle-down mx-2"></i>
                            </div>
                        </div>
                    </div>


                    {{-- Extended Search Input --}}
                    <div class="col-auto">
                        <div class="input-group">
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                   placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">
                            <button type="submit" class="btn btn-info">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Date & Time') }}</th>
                        <th>{{ __('Description') .' | ' . __('Method') }}</th>
                        <th>{{ __('User | TXN ID') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Fee') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($depositRequests as $depositRequest)
                        @php
                            $color = ['pending' => 'info', 'completed' => 'success', 'failed' => 'danger'][$depositRequest->status] ?? 'blue';
                        @endphp
                        <tr class="align-middle">
                            <td>
                                <div class="fw-bold">{{ $depositRequest->created_at_time }}</div>
                                <div class="text-muted small">{{ $depositRequest->created_at->diffForHumans() }}</div>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $depositRequest->description }}</div>
                                <div class="text-muted small">{{ ucwords($depositRequest->method) }}</div>
                            </td>
                            <td class="fw-bold">
                                <div class="d-flex align-items-center">
                                    <img class="me-2 rounded-circle" width="36" height="36" alt="Image placeholder" src="{{ asset($depositRequest->user->avatar) }}">
                                    <div>
                                        <a href="{{ route('admin.users.manage', $depositRequest->user->id) }}" class="text-secondary fw-bold">{{ $depositRequest->user->full_name }}</a>
                                        <div class="text-muted small">{{ strtoupper($depositRequest->txid) }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="text-{{ $color }} fw-bold">
                                    {{ ($depositRequest->status == \App\Constants\TxnStatus::COMPLETED && $depositRequest->type == \App\Constants\TxnType::DEPOSIT ? '+' : '') . $depositRequest->amount . ' ' . $depositRequest->currency }}
                                </div>

                                <div class="text-muted small">{{ title($depositRequest->type) }}</div>
                            </td>
                            <td class="fw-bold">
                                {{$depositRequest->fee . ' ' . $depositRequest->currency}}
                            </td>
                            <td class="fw-bold">
                                <button class="btn btn-tertiary edit-modal" data-edit-url="{{ route('admin.deposit.deposit-request-action', $depositRequest->txid) }}" type="button"><x-svg i="action" height="20"/>{{ __('Approve/Decline') }}</button>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>

    @include('backend.deposit.partials._deposit_action_modal')
@endsection
@push('script')
    <script>
        $(document).ready(function () {
            'use strict';
            editFormByModal('deposit-action-modal', 'deposit-action-data',true,true);
        });
    </script>

@endpush
