@extends('backend.deposit.index')
@section('title', __('Deposit History'))
@section('deposit_header')
    <div class="clearfix my-3">
        <div class="fs-2 fw-semibold float-start">@yield('title')</div>
    </div>
@endSection

@section('deposit_content')
    <div class="card border-0 mb-4">
        <div class="card-body px-2">
            <div class="fs-2 d-flex justify-content-end mb-2">
                <form action="{{ route('admin.deposit.history') }}" class="row g-2 align-items-end">

                    <div class="col-auto">
                        <input type="hidden" name="daterange" value="{{ request('daterange') }}">
                        <div class="input-group">
                            <div id="reportrange" class="form-control">
                                <i class="fa-solid fa-calendar-days"></i>&nbsp;
                                <span></span><i class="fa-solid fa-angle-down mx-2"></i>
                            </div>
                        </div>
                    </div>


                    {{-- Status Filter Dropdown --}}
                    <div class="col-auto">
                        <select class="form-select pe-5" name="status" aria-label="{{ __('Filter by Status') }}">
                            <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>{{ __('All Status') }}</option>
                            @foreach(\App\Constants\TxnStatus::STATUS as $key => $value)
                                <option value="{{ $value }}" {{ request('status') == $value ? 'selected' : '' }}>
                                    {{ ucwords($value) }}
                                </option>
                            @endforeach
                        </select>
                    </div>

                    {{-- Extended Search Input --}}
                    <div class="col-auto">
                        <div class="input-group">
                            <input type="text" name="search" value="{{ request('search') }}" class="form-control"
                                   placeholder="{{ __('Search...') }}" aria-label="{{ __('Search ...') }}">
                            <button type="submit" class="btn btn-info">
                                <i class="fa-solid fa-magnifying-glass"></i>
                            </button>
                        </div>
                    </div>
                </form>
            </div>
            <div class="table-responsive rounded">
                <table class="table table-bordered  table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('User | TXN ID') }}</th>
                        <th>{{ __('Amount') .' | ' . __('Type') }}</th>
                        <th>{{ __('Description | Fee') }}</th>
                        <th>{{ __('Method') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Time') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($depositHistories as $depositHistory)
                        @php
                            $color = ['pending' => 'info', 'completed' => 'success', 'failed' => 'danger'][$depositHistory->status] ?? 'blue';
                        @endphp
                        <tr class="align-middle ">
                            <td class="fw-bold">
                                <div class="d-flex align-items-center">
                                    <img class="me-2 rounded-circle" width="36" height="36" alt="Image placeholder" src="{{ asset($depositHistory->user->avatar) }}">
                                    <div>
                                        <a href="{{ route('admin.users.edit', $depositHistory->user->id) }}" class="text-secondary fw-bold">{{ $depositHistory->user->full_name }}</a>
                                        <div class="text-muted small">{{ strtoupper($depositHistory->txid) }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="text-{{ $color }} fw-bold">
                                    {{ ($depositHistory->status == \App\Constants\TxnStatus::COMPLETED && $depositHistory->type == \App\Constants\TxnType::DEPOSIT ? '+' : '') . $depositHistory->amount . ' ' . $depositHistory->currency }}
                                </div>
                                <div class="text-muted small">{{ title($depositHistory->type) }}</div>
                            </td>
                            <td class="fw-bold">
                                <div class="fw-bold">{{ $depositHistory->description }}</div>
                                <div class="text-muted small"> {{$depositHistory->fee . ' ' . $depositHistory->currency}}</div>
                            </td>
                            <td class="fw-bold">
                                {{$depositHistory->method}}
                            </td>
                            <td>
                                <span class="badge bg-{{ $color }} ">{{ strtoupper($depositHistory->status) }}</span>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $depositHistory->created_at_time }}</div>
                                <div class="text-muted small">{{ $depositHistory->created_at->diffForHumans() }}</div>
                            </td>

                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>

        </div>
    </div>
@endsection
