<div class="col-12 col-xxl-4 mb-3 mb-xxl-0">
    <div class="card">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0">{{ __('Top Services') }}</h3>
        </div>
        <div class="card-body">
            <div id="dashboard-service-chart" class="chart-lg"></div>
        </div>
    </div>
</div>


@push('script')
    <script>
        $(document).ready(function () {
            'use strict';


            // Service statistics data from backend
            let serviceStatistic = @json($serviceStatistics);

            // Extract keys (labels) and values (data)
            let serviceStatisticLabels = Object.keys(serviceStatistic).map(key => key.charAt(0).toUpperCase() + key.slice(1));
            let serviceStatisticValues = Object.values(serviceStatistic);

            // Optimize chart options
            const options = {
                series: serviceStatisticValues,
                chart: {
                    type: 'donut',
                    height: '334',  // Allows auto-sizing for flexibility
                    width: '100%',   // Adjust to fit parent container's width
                    parentHeightOffset: 0,
                },
                labels: serviceStatisticLabels,
                legend: {
                    position: 'bottom',  // More readable on smaller screens
                    markers: {
                        radius: 12  // Circular markers for aesthetics
                    }
                },
                dataLabels: {
                    enabled: true,  // Show percentage values on chart
                    formatter: function (val) {
                        return val.toFixed(1) + "%";  // Round percentages for cleaner display
                    }
                },
                responsive: [{
                    breakpoint: 480,
                    options: {
                        chart: {
                            width: 300  // Smaller size for mobile
                        },
                        legend: {
                            position: 'bottom'
                        }
                    }
                }],
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return val + " orders";  // Customize tooltip text
                        }
                    }
                }
            };

            // Initialize and render the chart
            const chart = new ApexCharts(document.querySelector("#dashboard-service-chart"), options);
            chart.render();
        });
    </script>
@endpush
