<div class="row g-3">
    @foreach($cardStatistics as $statistic)
        <div class="col-6 col-md-4 col-lg-3">
            <div class="card card-sm h-100">
                <div class="card-body p-2 position-relative">
                    @if(isset($statistic['link']))
                        <a href="{{ $statistic['link'] }}"
                           class="position-absolute top-0 end-0 d-flex align-items-center fw-bold text-muted mt-2 me-2">
                            <i class="fa-regular fa-arrow-up-right-from-square text-{{ $statistic['color'] }}"></i>
                        </a>
                    @endif
                    <div class="row align-items-center">
                        <div class="col-auto">
                            <div class="icon-shape icon-shape-{{ $statistic['color'] }} rounded me-2">
                                <x-icon :name="$statistic['icon']" class="icon"/>
                            </div>
                        </div>
                        <div class="col">
                            <div class="fw-medium">
                                {{ $statistic['title'] }}
                            </div>
                            <div class="text-muted text-nowrap">
                                {{ $statistic['value'] }}
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @endforeach
</div>
