<div class="col-12 col-xxl-6">
    <!-- Latest Users Card -->
    <div class="card  mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h3 class="card-title mb-0">{{ __('Latest Users') }}</h3>
        </div>
        <div class="card-body p-2">
            <div class="table-responsive rounded">
                <table class="table table-striped mb-0">
                    <thead class="table-light">
                    <tr>
                        <th>{{ __('Name') .' | ' . __('Balance') }}</th>
                        <th>{{ __('Email') .' | ' . __('Status') }}</th>
                        <th>{{ __('Join Time') }}</th>
                        <th>{{ __('Action') }}</th>
                    </tr>
                    </thead>
                    <tbody>
                    @foreach($users as $user)
                        <tr class="align-middle">
                            <td>
                                <div class="d-flex align-items-center">
                                    <img class="rounded-circle me-2"
                                         src="{{ asset($user->avatar) }}"
                                         alt="{{ $user->full_name }}"
                                         height="40" width="40">
                                    <div>
                                        <div class="fw-bold">{{ $user->full_name }}</div>
                                        <div class="text-muted small">{{ setting('currency_symbol').$user->getBalance() }}</div>
                                    </div>
                                </div>
                            </td>
                            <td>
                                <div class="fw-bold">{{ maskEmail($user->email) }}</div>
                                <span class="badge bg-{{ $user->email_verified_at ? 'success' : 'danger' }}">
                                        {{ strtoupper($user->email_verified_at ? __('Verified') : __('Unverified')) }}
                                    </span>
                            </td>
                            <td>
                                <div class="fw-bold">{{ $user->created_at->format('d M, Y') }}</div>
                                <div class="text-muted small">{{ $user->created_at->diffForHumans() }}</div>
                            </td>
                            <td>
                                <a href="{{ route('admin.users.manage', $user->id) }}" class="btn btn-sm btn-info">
                                    <x-icon name="manage" height="22" width="22" />
                                </a>
                            </td>
                        </tr>
                    @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
