<div class="col-12 col-xxl-6">
    <!-- Latest Orders Card -->
    <div class="card  mb-4">
        <div class="card-header d-flex flex-column flex-md-row align-items-md-center gap-2">
            <h3 class="card-title mb-0 me-auto">{{ __('Orders Statistics') }}</h3>
            <div class="col-auto d-flex gap-2">
                <input type="text" name="daterange" id="dashboard-daterange-orders" class="form-control"
                       value="{{ $orderDateRange }}" placeholder="{{ __('Select a date range') }}">
            </div>
        </div>

        <div class="card-body">
            <div id="dashboard-order-chart"></div>
        </div>
    </div>
</div>
@push('script')
    <script>
        $(document).ready(function () {
            'use strict';

            // Cache the DOM elements for the chart container and date range picker
            const $chartArea = $('#dashboard-order-chart');
            const $daterangeOrders = $('#dashboard-daterange-orders');

            // Get the Laravel-generated data as a JSON string
            let oderChartData = @json($oderChartData);

            // Prepare data for the chart
            const dates = Object.keys(oderChartData.pending); // Use any status to get the dates
            const pendingData = dates.map(date => oderChartData.pending[date] ?? 0);
            const workingData = dates.map(date => oderChartData.working[date] ?? 0);
            const completedData = dates.map(date => oderChartData.completed[date] ?? 0);
            const cancelledData = dates.map(date => oderChartData.cancelled[date] ?? 0);

            // Define the chart options using the prepared data
            const options = {
                series: [
                    {
                        name: 'Pending',
                        data: pendingData
                    },
                    {
                        name: 'Working',
                        data: workingData
                    },
                    {
                        name: 'Completed',
                        data: completedData
                    },
                    {
                        name: 'Cancelled',
                        data: cancelledData
                    }
                ],
                chart: {
                    type: 'bar',
                    height: 350,
                    toolbar: {
                        show: false // Hides the toolbar for a cleaner UI
                    }
                },
                plotOptions: {
                    bar: {
                        horizontal: false, // Vertical bar chart
                        columnWidth: '55%', // Column width
                        endingShape: 'rounded' // Rounded bar ends
                    }
                },
                dataLabels: {
                    enabled: false // Disable data labels for a cleaner look
                },
                stroke: {
                    show: true,
                    width: 2,
                    colors: ['transparent'] // Transparent stroke to separate bars
                },
                xaxis: {
                    categories: dates, // Use dates for x-axis categories
                    labels: {
                        style: {
                            colors: '#6c757d', // Add custom color for x-axis labels
                            fontSize: '12px'
                        }
                    }
                },
                yaxis: {
                    title: {
                        text: 'Orders Count' // Y-axis label
                    },
                    labels: {
                        style: {
                            colors: '#6c757d', // Custom color for y-axis labels
                            fontSize: '12px'
                        }
                    }
                },
                fill: {
                    opacity: 1 // Fully fill the bars
                },
                tooltip: {
                    y: {
                        formatter: function (val) {
                            return val + " orders"; // Custom tooltip formatter
                        }
                    }
                }
            };

            // Initialize and render the order chart
            const chart = new ApexCharts($chartArea[0], options);
            chart.render();

            // Initialize the date range picker
            $daterangeOrders.daterangepicker({
                opens: 'left'
            }, function (start, end) {
                fetchOrdersData(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
            });

            // Function to fetch data based on the selected date range
            function fetchOrdersData(startDate, endDate) {
                $.ajax({
                    url: '{{ route('admin.dashboard', ['type' => 'order']) }}', // Update this URL to your route
                    method: 'GET',
                    data: {
                        start_date: startDate,
                        end_date: endDate
                    },
                    success: function (data) {

                        console.log(data);

                        // Update the chart with the new data
                        updateOrderChart(data);
                    },
                    error: function () {
                        console.error('Error fetching order data.');
                    }
                });
            }

            // Function to update the order chart with new data
            function updateOrderChart(data) {
                const newDates = Object.keys(data.pending); // Use any status to get the dates
                const newPendingData = newDates.map(date => data.pending[date] ?? 0);
                const newWorkingData = newDates.map(date => data.working[date] ?? 0);
                const newCompletedData = newDates.map(date => data.completed[date] ?? 0);
                const newCancelledData = newDates.map(date => data.cancelled[date] ?? 0);

                // Update the chart's series and categories with new data
                chart.updateSeries([
                    { name: 'Pending', data: newPendingData },
                    { name: 'Working', data: newWorkingData },
                    { name: 'Completed', data: newCompletedData },
                    { name: 'Cancelled', data: newCancelledData }
                ]);

                // Update the x-axis categories with new dates
                chart.updateOptions({
                    xaxis: {
                        categories: newDates
                    }
                });
            }
        });
    </script>
@endpush
