<?php

namespace App\Http\Requests\Subscription;

use Illuminate\Foundation\Http\FormRequest;

class StoreSubscriptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // Allow only authenticated users to make subscriptions
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'txn_type' => 'required', // Validate transaction type for subscription or renewal
            'plan_id' => 'required|exists:plans,id', // Plan must exist
            'plan_type' => 'required|in:monthly,yearly', // Plan type must be either monthly or yearly
            'deposit_method' => 'required|string', // Deposit method is required
            'manual_data' => 'nullable|array', // Optional manual data, must be an array if provided
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'txn_type.required' => __('The transaction type is required.'),
            'txn_type.in' => __('The transaction type must be either subscribe or renew.'),
            'plan_id.required' => __('You must select a valid plan.'),
            'plan_id.exists' => __('The selected plan does not exist.'),
            'plan_type.required' => __('You must select a valid plan type.'),
            'plan_type.in' => __('The plan type must be either monthly or yearly.'),
            'deposit_method.required' => __('You must select a valid deposit method.'),
            'deposit_method.string' => __('The deposit method must be a valid string.'),
        ];
    }
}
