<?php

namespace App\Http\Requests\Subscription;

use Illuminate\Foundation\Http\FormRequest;

class RequestNowSubscriptionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        // Allow only authenticated users to request subscriptions
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'plan_id' => 'required|exists:plans,id', // The plan must exist
            'plan_type' => 'required|in:monthly,yearly', // Plan type must be monthly or yearly
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array
     */
    public function messages()
    {
        return [
            'plan_id.required' => __('You must select a valid plan.'),
            'plan_id.exists' => __('The selected plan does not exist.'),
            'plan_type.required' => __('You must select a valid plan type.'),
            'plan_type.in' => __('The plan type must be either monthly or yearly.'),
        ];
    }
}
