<?php

namespace App\Constants;

class TimeUnits
{
    const MINUTE = 1;
    const HOUR = 60;
    const DAY = 1440;

    public static function getAll(): array
    {
        return [
            self::MINUTE => __('Minute'),
            self::HOUR => __('Hour'),
            self::DAY => __('Day'),
        ];
    }

    public static function getUnitName(int $unit): string
    {
        return self::getAll()[$unit] ?? '';
    }

    public static function getUnitValue(int $unit): int
    {
        return self::getAll()[$unit] ?? 0;
    }
}
